<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Api extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->database();
        $this->load->helper('url');
    }

    public function execute_query() {
        // Check if request method is POST
        // if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        //     show_error('Invalid request method', 405);
        // }

        // Get the raw POST data
        $postData = file_get_contents("php://input");
        $requestData = json_decode($postData, true);

        // Validate the received data
        if (!isset($requestData['query']) || empty($requestData['query'])) {
            show_error('Invalid query', 400);
        }

        $query = $requestData['query'];

        // Execute the query
        try {
            $result = $this->db->query($query);
            if ($result) {
                if ($result->num_rows() > 0) {
                    $rows = $result->result_array(); // Fetch result as array
                    $response = array('status' => 'success', 'data' => $rows);
                } else {
                    $response = array('status' => 'success', 'message' => 'Query executed successfully but no results found');
                }
            } else {
                $response = array('status' => 'success', 'message' => 'Query executed successfully but no rows affected');
            }
        } catch (Exception $e) {
            $response = array('status' => 'error', 'message' => $e->getMessage());
        }

        // Send the response
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }
}